Ext.data.JsonP.sol_common_CounterUtils({"tagname":"class","name":"sol.common.CounterUtils","autodetected":{"aliases":true,"alternateClassNames":true,"extends":true,"mixins":true,"requires":true,"uses":true,"members":true,"code_type":true,"singleton":true},"files":[{"filename":"lib_sol.common.CounterUtils.js","href":"lib_sol.common.CounterUtils.html#sol-common-CounterUtils"}],"author":[{"tagname":"author","name":"Pascal Zipfel, ELO Digital Office GmbH","email":null}],"version":["1.04.002"],"elojc":true,"eloas":true,"eloix":true,"aliases":{},"alternateClassNames":[],"extends":"sol.Base","mixins":[],"requires":[],"uses":[],"members":[{"name":"requiredConfig","tagname":"cfg","owner":"sol.Base","id":"cfg-requiredConfig","meta":{"protected":true}},{"name":"$className","tagname":"property","owner":"sol.Base","id":"property-S-className","meta":{"protected":true}},{"name":"logger","tagname":"property","owner":"sol.Base","id":"property-logger","meta":{"protected":true}},{"name":"$super","tagname":"method","owner":"sol.Base","id":"method-S-super","meta":{"private":true}},{"name":"create","tagname":"method","owner":"sol.common.CounterUtils","id":"method-create","meta":{}},{"name":"exists","tagname":"method","owner":"sol.common.CounterUtils","id":"method-exists","meta":{}},{"name":"getValue","tagname":"method","owner":"sol.common.CounterUtils","id":"method-getValue","meta":{}},{"name":"incCounter","tagname":"method","owner":"sol.common.CounterUtils","id":"method-incCounter","meta":{}},{"name":"initialize","tagname":"method","owner":"sol.Base","id":"method-initialize","meta":{"private":true}},{"name":"normalizeName","tagname":"method","owner":"sol.common.CounterUtils","id":"method-normalizeName","meta":{"private":true}}],"code_type":"ext_define","singleton":true,"id":"class-sol.common.CounterUtils","short_doc":"Utility functions for counter. ...","classIcon":"icon-singleton","superclasses":["sol.Base"],"subclasses":[],"mixedInto":[],"parentMixins":[],"html":"<div><pre class=\"hierarchy\"><h4>Hierarchy</h4><div class='subclass first-child'><a href='#!/api/sol.Base' rel='sol.Base' class='docClass'>sol.Base</a><div class='subclass '><strong>sol.common.CounterUtils</strong></div></div><h4>Files</h4><div class='dependency'><a href='source/lib_sol.common.CounterUtils.html#sol-common-CounterUtils' target='_blank'>lib_sol.common.CounterUtils.js</a></div></pre><div class='doc-contents'><p>Utility functions for counter.</p>\n\n<p>All counter-names will be normalized, by transforming them to upper case and replacing <code>&amp;</code> with <code>__</code>.</p>\n\n<pre><code>// Generate the next record id for filing plan reference 1202.22\nvar nextRecordId = <a href=\"#!/api/sol.common.CounterUtils-method-incCounter\" rel=\"sol.common.CounterUtils-method-incCounter\" class=\"docClass\">sol.common.CounterUtils.incCounter</a>('RECORDS-FP.1202.22', 1);\n</code></pre>\n      <p class='version-tag'>Version: <b>1.04.002</b></p>\n</div><div class='members'><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-cfg'>Config options</h3><div class='subsection'><div id='cfg-requiredConfig' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-cfg-requiredConfig' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-cfg-requiredConfig' class='name expandable'>requiredConfig</a> : Array<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>List of required config properties. ...</div><div class='long'><p>List of required config properties. <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a> throws an exception if one of the properties is null or undefined.</p>\n</div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-property'>Properties</h3><div class='subsection'><div id='property-S-className' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-property-S-className' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-property-S-className' class='name expandable'>$className</a> : Object<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'><p>{String}\nname of the class including its namespace.</p>\n</div><div class='long'><p>{String}\nname of the class including its namespace.</p>\n</div></div></div><div id='property-logger' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-property-logger' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-property-logger' class='name expandable'>logger</a> : <a href=\"#!/api/sol.Logger\" rel=\"sol.Logger\" class=\"docClass\">sol.Logger</a><span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>Logger for this class instance. ...</div><div class='long'><p>Logger for this class instance. This logger is created by <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a>.</p>\n\n<p>Please see <a href=\"#!/api/sol.Logger\" rel=\"sol.Logger\" class=\"docClass\">sol.Logger</a> class documentation for more information.</p>\n</div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-method'>Methods</h3><div class='subsection'><div id='method-S-super' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-method-S-super' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-method-S-super' class='name expandable'>$super</a>( <span class='pre'>superClassName, functionName, arguments</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Calls a function of a superclass thanks to its name. ...</div><div class='long'><p>Calls a function of a superclass thanks to its name. Superclass must be part of the calling objects class hierarchy.</p>\n\n<p><b>Please note that calling superclass functions might lead to an infinitive loop if misused. Please validate that none class other than the classes superclass is passed as the superclass parent.</b></p>\n\n<pre><code>me.$super(superClassName, functionName, attributesArray);\n</code></pre>\n\n<p>A basic example of the initialize-function will look as followed.</p>\n\n<pre><code>me.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", [config]);\nme.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", arguments);\n</code></pre>\n\n<p>A word on performance: The superclass name must be passed since the js rhino engine does not allow accessing the caller of the callee due to performance reasons.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>superClassName</span> : String<div class='sub-desc'><p>name of the super class.</p>\n</div></li><li><span class='pre'>functionName</span> : String<div class='sub-desc'><p>name of the function that should be called.</p>\n</div></li><li><span class='pre'>arguments</span> : Object[]<div class='sub-desc'><p>list of arguments that should be passed to the function.</p>\n</div></li></ul></div></div></div><div id='method-create' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.CounterUtils'>sol.common.CounterUtils</span><br/><a href='source/lib_sol.common.CounterUtils.html#sol-common-CounterUtils-method-create' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.CounterUtils-method-create' class='name expandable'>create</a>( <span class='pre'>name, [value]</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Creates a new counter or updates an existing one. ...</div><div class='long'><p>Creates a new counter or updates an existing one.</p>\n\n<p>Be carefull, if counter already exists, it will be overwritten.\nYou might want to use <a href=\"#!/api/sol.common.CounterUtils-method-incCounter\" rel=\"sol.common.CounterUtils-method-incCounter\" class=\"docClass\">incCounter</a> instead.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>name</span> : String<div class='sub-desc'><p>The name of the counter</p>\n</div></li><li><span class='pre'>value</span> : Number (optional)<div class='sub-desc'><p>The initial counter value</p>\n<p>Defaults to: <code>1</code></p></div></li></ul></div></div></div><div id='method-exists' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.CounterUtils'>sol.common.CounterUtils</span><br/><a href='source/lib_sol.common.CounterUtils.html#sol-common-CounterUtils-method-exists' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.CounterUtils-method-exists' class='name expandable'>exists</a>( <span class='pre'>name</span> ) : Boolean<span class=\"signature\"></span></div><div class='description'><div class='short'>Checks if a counter exists without modifying it. ...</div><div class='long'><p>Checks if a counter exists without modifying it.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>name</span> : String<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getValue' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.CounterUtils'>sol.common.CounterUtils</span><br/><a href='source/lib_sol.common.CounterUtils.html#sol-common-CounterUtils-method-getValue' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.CounterUtils-method-getValue' class='name expandable'>getValue</a>( <span class='pre'>name, [noInc]</span> ) : Number<span class=\"signature\"></span></div><div class='description'><div class='short'>Retrives the value of a counter. ...</div><div class='long'><p>Retrives the value of a counter.</p>\n\n<p>If not spezified differently, it will automatically increment the counter.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>name</span> : String<div class='sub-desc'>\n</div></li><li><span class='pre'>noInc</span> : Boolean (optional)<div class='sub-desc'><p>If <code>true</code>, the counter will NOT be incremented (use carefully)</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Number</span><div class='sub-desc'><p>The value of the counter</p>\n</div></li></ul><h3 class='pa'>Throws</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'><p>Throws an exception, if counter does not exist</p>\n</div></li></ul></div></div></div><div id='method-incCounter' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.CounterUtils'>sol.common.CounterUtils</span><br/><a href='source/lib_sol.common.CounterUtils.html#sol-common-CounterUtils-method-incCounter' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.CounterUtils-method-incCounter' class='name expandable'>incCounter</a>( <span class='pre'>name, [defaultValue]</span> ) : Number<span class=\"signature\"></span></div><div class='description'><div class='short'>Returns the next value of a counter, or creates a new one. ...</div><div class='long'><p>Returns the next value of a counter, or creates a new one.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>name</span> : String<div class='sub-desc'><p>The name of the counter</p>\n</div></li><li><span class='pre'>defaultValue</span> : Number (optional)<div class='sub-desc'><p>The default value of the counter, if a new one is created</p>\n<p>Defaults to: <code>1</code></p></div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Number</span><div class='sub-desc'><p>The counter value</p>\n</div></li></ul></div></div></div><div id='method-initialize' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-method-initialize' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-method-initialize' class='name expandable'>initialize</a>( <span class='pre'>config</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Initialize class. ...</div><div class='long'><p>Initialize class.\nThis function is called after the class was instantiated.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>config</span> : Object<div class='sub-desc'><p>parameters as defined. See documentation for more details.</p>\n</div></li></ul></div></div></div><div id='method-normalizeName' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.CounterUtils'>sol.common.CounterUtils</span><br/><a href='source/lib_sol.common.CounterUtils.html#sol-common-CounterUtils-method-normalizeName' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.CounterUtils-method-normalizeName' class='name expandable'>normalizeName</a>( <span class='pre'>name</span> ) : String<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Performes the normalization on the counter name converts to upper case and replace &amp;. ...</div><div class='long'><p>Performes the normalization on the counter name converts to upper case and replace <code>&amp;</code>.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>name</span> : String<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'><p>The normalized name</p>\n</div></li></ul></div></div></div></div></div></div></div>","meta":{"eloas":true,"eloix":true,"elojc":true,"singleton":true}});